/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal.SignalEvent;

import java.net.*;

import cnrg.itx.signal.*;

/** This class represents an event generated when an alive request is received.  This event is
 *  not passed up to the application and is handled by DesktopSignaling.
 */
public class AliveSignalEvent extends SignalEvent
{
	/** Default Constructor
	 * 
	 * @param ip is the InvitePacket received
	 */
	public AliveSignalEvent(InvitePacket ip){
		super(ip);
	}
	
	/** This method is used by DesktopSignaling to confirm that the application is alive.
	 * 
	 * @param None.
	 * @return void.
	 */
	public void confirm(){
		myInviteInfo.setPacketType(SignalID.CONFIRM);
		myInviteInfo.confirm();
	}
}
